//this file is part of eMule
//Copyright (C)2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once

enum EReason
{
	REASON_NoNeededParts,
	REASON_Timeout,
	REASON_Disconnect,
	REASON_Cancel,
	REASON_Limit,
	REASON_Dropped,
	REASON_Unreachable,
	REASON_Rejected,
	REASON_Other,
	REASON_None
};

enum ESmallFilePush
{
	SFP_None = 0,
	SFP_Nonlinear = 1,
	SFP_Full = 2
};

enum ETaskPriority
{
	TP_Low = 0,
	TP_BelowNormal = 1,
	TP_Normal = 2,
	TP_AboveNormal = 3,
	TP_High = 4
};

class CNetF
{
	// netfinity: Clean this later
	friend class CPPgNetF;
	friend class CPreferences;
	friend class CServerConnect;
	friend class CListenSocket;
	friend class CClientReqSocket;
	friend class CDownloadQueue;
	friend class CemuleDlg;
	friend class CUploadListCtrl;
	friend class CQueueListCtrl;
	friend class CClientCredits;
	friend class CUploadQueue;
	friend class CPartFile;
	friend class CUpDownClient;
	friend class CStatisticsDlg;

	// Status
	bool			m_bHighIdPossible;
	// Statistics
	uint32			m_iSessionSuccessfulDownloadNNP;
	uint32			m_iSessionSuccessfulDownloadLimit;
	uint32			m_iSessionSuccessfulDownloadTimeout;
	uint32			m_iSessionSuccessfulDownloadDisconnect;
	uint32			m_iSessionSuccessfulDownloadDropped;
	uint32			m_iSessionSuccessfulDownloadOther;
	uint32			m_iSessionFailedDownloadNNP;
	uint32			m_iSessionFailedDownloadLimit;
	uint32			m_iSessionFailedDownloadTimeout;
	uint32			m_iSessionFailedDownloadDisconnect;
	uint32			m_iSessionFailedDownloadDropped;
	uint32			m_iSessionFailedDownloadOther;
	uint32			m_iSessionSuccessfulUploadCancel;
	uint32			m_iSessionSuccessfulUploadTimeout;
	uint32			m_iSessionSuccessfulUploadDisconnect;
	uint32			m_iSessionSuccessfulUploadLimit;
	uint32			m_iSessionSuccessfulUploadOther;
	uint32			m_iSessionFailedUploadCancel;
	uint32			m_iSessionFailedUploadTimeout;
	uint32			m_iSessionFailedUploadDisconnect;
	uint32			m_iSessionFailedUploadLimit;
	uint32			m_iSessionFailedUploadUnreachable;
	uint32			m_iSessionFailedUploadRejected;
	uint32			m_iSessionFailedUploadOther;
	uint64			m_nSessionUploadedLAN;
	uint64			m_nSessionDownloadedLAN;
	// Configuration
	bool			m_bSymmetricTCP;
	ETaskPriority	m_iTaskPriority;
	ESmallFilePush	m_iSmallFilePush;
	// Features
	bool			m_bVIPQueue;
	// Locale
	typedef		CMap<UINT, UINT, CString, CString> CLocMap;
	CLocMap			m_mapLocaleStrings;
public:
	CNetF();
	~CNetF();
	void			Init(void);
	ESmallFilePush	GetSmallFilePush(void) const {return m_iSmallFilePush;}
	void			LoadPreferences(void);
	void			SavePreferences(void) const;
	void			LoadLocale(const CString& strLanguage);
	const CString&	GetLocaleString(UINT nID, const CString& strDefault);
	void			UpdateTaskPriority(void);
};

extern CNetF theNetF;
